/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingDeliveryman;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.client.gui.WindowHutMinPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.WarehouseModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.DeliveryRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PickupRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseConcreteRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingWareHouse
extends AbstractBuilding
implements IWareHouse {
    private static final String WAREHOUSE = "warehouse";
    private static final String TAG_DELIVERYMAN = "deliveryman";
    private final Set<Vector3d> registeredDeliverymen = new HashSet<Vector3d>();
    private static final int MAX_LEVEL = 5;
    public static final int MAX_STORAGE_UPGRADE = 3;

    public BuildingWareHouse(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void requestRepair(BlockPos builder) {
        for (BlockPos pos : this.containerList) {
            TileEntity entity;
            if (this.getColony().getWorld() == null || !((entity = this.getColony().getWorld().func_175625_s(pos)) instanceof TileEntityRack)) continue;
            ((AbstractTileEntityRack)entity).setInWarehouse(true);
        }
        super.requestRepair(builder);
    }

    @Override
    public boolean registerWithWareHouse(IBuildingDeliveryman buildingWorker) {
        if (this.registeredDeliverymen.contains(new Vector3d((double)buildingWorker.getID().func_177958_n(), (double)buildingWorker.getID().func_177956_o(), (double)buildingWorker.getID().func_177952_p()))) {
            return true;
        }
        if (this.registeredDeliverymen.size() >= this.getMaxAssignedDmen()) {
            if (!this.registeredDeliverymen.isEmpty()) {
                this.checkForRegisteredDeliverymen();
            }
            if (this.registeredDeliverymen.size() >= this.getMaxAssignedDmen()) {
                return false;
            }
        }
        this.registeredDeliverymen.add(new Vector3d((double)buildingWorker.getID().func_177958_n(), (double)buildingWorker.getID().func_177956_o(), (double)buildingWorker.getID().func_177952_p()));
        return true;
    }

    @Override
    public void unregisterFromWareHouse(IBuildingDeliveryman buildingWorker) {
        Vector3d vec = new Vector3d((double)buildingWorker.getID().func_177958_n(), (double)buildingWorker.getID().func_177956_o(), (double)buildingWorker.getID().func_177952_p());
        this.registeredDeliverymen.remove(vec);
    }

    private int getMaxAssignedDmen() {
        return this.getBuildingLevel() * 2;
    }

    private void checkForRegisteredDeliverymen() {
        for (Vector3d pos : new ArrayList<Vector3d>(this.registeredDeliverymen)) {
            IColony colony = this.getColony();
            IBuilding building = colony.getBuildingManager().getBuilding(new BlockPos(pos));
            if (building instanceof BuildingDeliveryman && building.hasAssignedCitizen()) continue;
            this.registeredDeliverymen.remove(pos);
        }
    }

    @Override
    public boolean canAccessWareHouse(IBuildingDeliveryman buildingWorker) {
        return this.registeredDeliverymen.contains(new Vector3d((double)buildingWorker.getID().func_177958_n(), (double)buildingWorker.getID().func_177956_o(), (double)buildingWorker.getID().func_177952_p()));
    }

    @Override
    public Set<Vector3d> getRegisteredDeliverymen() {
        return new HashSet<Vector3d>(Collections.unmodifiableSet(this.registeredDeliverymen));
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.registeredDeliverymen.clear();
        ListNBT deliverymanTagList = compound.func_150295_c(TAG_DELIVERYMAN, 10);
        for (int i = 0; i < deliverymanTagList.size(); ++i) {
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)deliverymanTagList.func_150305_b(i));
            if (this.getColony() == null || !(this.getColony().getBuildingManager().getBuilding(pos) instanceof AbstractBuildingWorker)) continue;
            this.registeredDeliverymen.add(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT levelTagList = new ListNBT();
        for (Vector3d deliverymanBuilding : this.registeredDeliverymen) {
            levelTagList.add((Object)NBTUtil.func_186859_a((BlockPos)new BlockPos(deliverymanBuilding)));
        }
        compound.func_218657_a(TAG_DELIVERYMAN, (INBT)levelTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return WAREHOUSE;
    }

    @Override
    public AbstractTileEntityWareHouse getTileEntity() {
        AbstractTileEntityColonyBuilding entity = super.getTileEntity();
        return !(entity instanceof TileEntityWareHouse) ? null : (AbstractTileEntityWareHouse)entity;
    }

    @Override
    public boolean hasContainerPosition(BlockPos inDimensionLocation) {
        return this.containerList.contains(inDimensionLocation) || this.getLocation().getInDimensionLocation().equals((Object)inDimensionLocation);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof BlockMinecoloniesRack) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof ChestTileEntity) {
                BuildingWareHouse.handleBuildingOverChest(pos, (ChestTileEntity)entity, world, null);
            }
            if (entity instanceof TileEntityRack) {
                ((AbstractTileEntityRack)entity).setInWarehouse(true);
            }
        }
        super.registerBlockPosition(block, pos, world);
    }

    public static void handleBuildingOverChest(@NotNull BlockPos pos, ChestTileEntity chest, World world, @Nullable CompoundNBT tileEntityData) {
        TileEntity entity;
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        int size = chest.func_70302_i_();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = chest.func_70301_a(slot);
            if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                inventory.add(stack.func_77946_l());
            }
            chest.func_70304_b(slot);
        }
        world.func_180501_a(pos, ModBlocks.blockRack.func_176223_P(), 3);
        if (tileEntityData != null) {
            PlacementHandlers.handleTileEntityPlacement((CompoundNBT)tileEntityData, (World)world, (BlockPos)pos);
        }
        if ((entity = world.func_175625_s(pos)) instanceof TileEntityRack) {
            ((AbstractTileEntityRack)entity).setInWarehouse(true);
            for (ItemStack stack : inventory) {
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                InventoryUtils.addItemStackToItemHandler((IItemHandler)((AbstractTileEntityRack)entity).getInventory(), stack);
            }
        }
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object[])new IRequestResolver[]{new WarehouseRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new WarehouseConcreteRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN))});
        builder.add((Object)new DeliveryRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PickupRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.wareHouse;
    }

    @Override
    public void upgradeContainers(World world) {
        if (this.getFirstModuleOccurance(WarehouseModule.class).getStorageUpgrade() < 3) {
            for (BlockPos pos : this.getContainers()) {
                TileEntity entity = world.func_175625_s(pos);
                if (!(entity instanceof TileEntityRack) || entity instanceof TileEntityColonyBuilding) continue;
                ((AbstractTileEntityRack)entity).upgradeItemStorage();
            }
            this.getFirstModuleOccurance(WarehouseModule.class).incrementStorageUpgrade();
        }
        this.markDirty();
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutMinPlaceholder<View>(this, BuildingWareHouse.WAREHOUSE);
        }
    }
}

